/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.api;

import io.wispforest.accessories.api.AccessoriesAPI;
import io.wispforest.accessories.api.Accessory;
import io.wispforest.accessories.api.DropRule;
import io.wispforest.accessories.api.attributes.AccessoryAttributeBuilder;
import io.wispforest.accessories.api.components.AccessoriesDataComponents;
import io.wispforest.accessories.api.components.AccessoryNestContainerContents;
import io.wispforest.accessories.api.events.SlotStateChange;
import io.wispforest.accessories.api.slot.SlotEntryReference;
import io.wispforest.accessories.api.slot.SlotReference;
import io.wispforest.accessories.api.slot.SlotType;
import io.wispforest.accessories.impl.AccessoryNestUtils;
import io.wispforest.accessories.pond.stack.PatchedDataComponentMapExtension;
import it.unimi.dsi.fastutil.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.class_1282;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_2561;
import net.minecraft.class_9323;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.jetbrains.annotations.Nullable;

public interface AccessoryNest
extends Accessory {
    default public List<class_1799> getInnerStacks(class_1799 holderStack) {
        AccessoryNestContainerContents data = (AccessoryNestContainerContents)holderStack.method_57824(AccessoriesDataComponents.NESTED_ACCESSORIES);
        return data == null ? List.of() : data.accessories();
    }

    default public boolean setInnerStack(class_1799 holderStack, int index, class_1799 newStack) {
        if (!AccessoryNest.isAccessoryNest(holderStack)) {
            return false;
        }
        if (AccessoryNest.isAccessoryNest(newStack) && !this.allowDeepRecursion()) {
            return false;
        }
        holderStack.method_57368(AccessoriesDataComponents.NESTED_ACCESSORIES, (Object)new AccessoryNestContainerContents(List.of()), contents -> contents.setStack(index, newStack));
        return true;
    }

    default public boolean allowDeepRecursion() {
        return false;
    }

    default public List<Pair<DropRule, class_1799>> getDropRules(class_1799 stack, SlotReference reference, class_1282 source) {
        ArrayList<Pair<DropRule, class_1799>> innerRules = new ArrayList<Pair<DropRule, class_1799>>();
        List<class_1799> innerStacks = this.getInnerStacks(stack);
        for (int i = 0; i < innerStacks.size(); ++i) {
            class_1799 innerStack = innerStacks.get(i);
            DropRule rule = AccessoriesAPI.getOrDefaultAccessory(innerStack).getDropRule(innerStack, reference, source);
            innerRules.add((Pair<DropRule, class_1799>)Pair.of((Object)((Object)rule), (Object)innerStack));
        }
        return innerRules;
    }

    public static <T> T attemptFunction(class_1799 holderStack, SlotReference slotReference, Function<Map<SlotEntryReference, Accessory>, T> func, T defaultValue) {
        AccessoryNestContainerContents data = AccessoryNestUtils.getData(holderStack);
        if (data == null) {
            return defaultValue;
        }
        T t = func.apply(data.getMap(slotReference));
        AccessoryNest.checkIfChangesOccurred(holderStack, null, data);
        return t;
    }

    public static <T> T attemptFunction(class_1799 holderStack, @Nullable class_1309 livingEntity, Function<Map<class_1799, Accessory>, T> func, T defaultValue) {
        AccessoryNestContainerContents data = AccessoryNestUtils.getData(holderStack);
        if (data == null) {
            return defaultValue;
        }
        T t = func.apply(data.getMap());
        AccessoryNest.checkIfChangesOccurred(holderStack, livingEntity, data);
        return t;
    }

    public static void attemptConsumer(class_1799 holderStack, SlotReference slotReference, Consumer<Map<SlotEntryReference, Accessory>> consumer) {
        AccessoryNestContainerContents data = AccessoryNestUtils.getData(holderStack);
        if (data == null) {
            return;
        }
        consumer.accept(data.getMap(slotReference));
        AccessoryNest.checkIfChangesOccurred(holderStack, slotReference.entity(), data);
    }

    public static void attemptConsumer(class_1799 holderStack, @Nullable class_1309 livingEntity, Consumer<Map<class_1799, Accessory>> consumer) {
        AccessoryNestContainerContents data = AccessoryNestUtils.getData(holderStack);
        if (data == null) {
            return;
        }
        consumer.accept(data.getMap());
        AccessoryNest.checkIfChangesOccurred(holderStack, livingEntity, data);
    }

    private static boolean checkIfChangesOccurred(class_1799 holderStack, @Nullable class_1309 livingEntity, AccessoryNestContainerContents data) {
        boolean hasChangeOccurred = false;
        List<class_1799> accessories = data.accessories();
        for (int i = 0; i < accessories.size(); ++i) {
            AccessoryNestContainerContents innerData;
            PatchedDataComponentMapExtension extension;
            class_1799 stack = accessories.get(i);
            class_9323 class_93232 = stack.method_57353();
            if (class_93232 instanceof PatchedDataComponentMapExtension && (extension = (PatchedDataComponentMapExtension)class_93232).accessories$hasChanged()) {
                hasChangeOccurred = true;
            } else if (data.slotChanges().containsKey(i)) {
                hasChangeOccurred = true;
            } else if (AccessoriesAPI.getOrDefaultAccessory(stack) instanceof AccessoryNest && (innerData = AccessoryNestUtils.getData(stack)) != null && (hasChangeOccurred = AccessoryNest.checkIfChangesOccurred(stack, livingEntity, innerData))) break;
            if (!hasChangeOccurred) continue;
            data.slotChanges().putIfAbsent(i, SlotStateChange.MUTATION);
        }
        if (hasChangeOccurred) {
            AccessoryNest nest = (AccessoryNest)AccessoriesAPI.getOrDefaultAccessory(holderStack);
            holderStack.method_57379(AccessoriesDataComponents.NESTED_ACCESSORIES, (Object)data);
            nest.onStackChanges(holderStack, data, livingEntity);
        }
        return hasChangeOccurred;
    }

    public static boolean isAccessoryNest(class_1799 holderStack) {
        return AccessoriesAPI.getOrDefaultAccessory(holderStack) instanceof AccessoryNest;
    }

    default public void onStackChanges(class_1799 holderStack, AccessoryNestContainerContents data, @Nullable class_1309 livingEntity) {
    }

    @Override
    default public void tick(class_1799 stack, SlotReference reference) {
        AccessoryNest.attemptConsumer(stack, reference, (Map<SlotEntryReference, Accessory> map) -> map.forEach((entryRef, accessory) -> accessory.tick(entryRef.stack(), entryRef.reference())));
    }

    @Override
    default public void onEquip(class_1799 stack, SlotReference reference) {
        AccessoryNest.attemptConsumer(stack, reference, (Map<SlotEntryReference, Accessory> map) -> map.forEach((entryRef, accessory) -> accessory.onEquip(entryRef.stack(), entryRef.reference())));
    }

    @Override
    default public void onUnequip(class_1799 stack, SlotReference reference) {
        AccessoryNest.attemptConsumer(stack, reference, (Map<SlotEntryReference, Accessory> map) -> map.forEach((entryRef, accessory) -> accessory.onUnequip(entryRef.stack(), entryRef.reference())));
    }

    @Override
    default public boolean canEquip(class_1799 stack, SlotReference reference) {
        return AccessoryNest.attemptFunction(stack, reference, (Map<SlotEntryReference, Accessory> map) -> {
            MutableBoolean canEquip = new MutableBoolean(true);
            map.forEach((entryRef, accessory) -> canEquip.setValue(canEquip.booleanValue() && accessory.canEquip(entryRef.stack(), entryRef.reference())));
            return canEquip.getValue();
        }, Boolean.valueOf(false));
    }

    @Override
    default public boolean canUnequip(class_1799 stack, SlotReference reference) {
        return AccessoryNest.attemptFunction(stack, reference, (Map<SlotEntryReference, Accessory> map) -> {
            MutableBoolean canUnequip = new MutableBoolean(true);
            map.forEach((entryRef, accessory) -> canUnequip.setValue(canUnequip.booleanValue() && accessory.canUnequip(entryRef.stack(), entryRef.reference())));
            return canUnequip.getValue();
        }, Boolean.valueOf(true));
    }

    @Override
    default public void getDynamicModifiers(class_1799 stack, SlotReference reference, AccessoryAttributeBuilder builder) {
        AccessoryNest.attemptConsumer(stack, reference, (Map<SlotEntryReference, Accessory> innerMap) -> innerMap.forEach((entryRef, accessory) -> accessory.getDynamicModifiers(entryRef.stack(), entryRef.reference(), new AccessoryAttributeBuilder(entryRef.reference(), builder))));
    }

    @Override
    default public void getAttributesTooltip(class_1799 stack, SlotType type, List<class_2561> tooltips, class_1792.class_9635 tooltipContext, class_1836 tooltipType) {
        AccessoryNest.attemptConsumer(stack, (class_1309)null, (Map<class_1799, Accessory> map) -> map.forEach((stack1, accessory) -> accessory.getAttributesTooltip((class_1799)stack1, type, tooltips, tooltipContext, tooltipType)));
    }

    @Override
    default public void getExtraTooltip(class_1799 stack, List<class_2561> tooltips, class_1792.class_9635 tooltipContext, class_1836 tooltipType) {
        AccessoryNest.attemptConsumer(stack, (class_1309)null, (Map<class_1799, Accessory> map) -> map.forEach((stack1, accessory) -> accessory.getExtraTooltip((class_1799)stack1, tooltips, tooltipContext, tooltipType)));
    }
}

